<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Captain Vape</title>
  
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

  <style>
    .top-bar-warning {
      background: #000; color: orange; font-weight: 500;
      padding: 10px; letter-spacing: 1.6px; text-align: center;
    }
    .top-bar-warning span { color: red; }
    .top-bar-info {
      background: #f8f8f8; color: #000; padding: 10px;
      text-align: center; font-weight: 600; font-size: 14px;
    }
    /* Mobile screen ke liye font size chhoti */
@media (max-width: 576px) {
  .top-bar-warning {
    font-size: 12px;       /* warning text chhota */
    padding: 6px;          /* padding bhi kam */
    letter-spacing: 1px;
  }
  .top-bar-warning span {
    font-size: 12px;
  }
  .top-bar-info {
    font-size: 12px;       /* info bar text chhota */
    padding: 6px;
  }
}


    .logo-section { background: #fec630; text-align: center; }
    .logo-section img { max-height: 90px; }
    .navbar { background: #fec630 !important; }
    .navbar-nav { margin: auto; }
    .nav-link { font-weight: 600; color: #000 !important; margin: 0 10px; }

    .btn-custom {
      background: #000; color: #fff; border-radius: 4px;
      padding: 5px 12px; font-size: 14px; margin-left: 6px;
      text-decoration: none;
    }

    /* Fullscreen Dropdown */
    .navbar .dropdown { position: static; }
    .dropdown-menu {
      position: absolute;
      top: 100%;
      left: 0;
      right: 0;
      width: 100%;
      margin: 0;
      border: none;
      border-radius: 0;
      padding: 40px 60px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.1);
      display: none;
      background: #fff;
      max-height: 500px;
      overflow-y: auto;
    }

    .dropdown-menu::-webkit-scrollbar { width: 6px; }
    .dropdown-menu::-webkit-scrollbar-thumb { background: #ccc; border-radius: 3px; }
    .dropdown-menu::-webkit-scrollbar-thumb:hover { background: #999; }

    .products-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      gap: 28px;
    }
    .product-item {
      font-size: 14px; font-weight: 500; line-height: 1.4;
      letter-spacing: 0.3px; transition: all 0.2s ease;
    }
    .product-item:hover { transform: translateX(4px); color: #111; }
    
    .product-link { 
      font-family: 'Poppins', sans-serif;
      font-size: 15px; 
      font-weight: 500; 
      color: #212121;
      text-decoration: none; 
      display: block; 
      line-height: 1.5; 
    }

    .product-link:hover { color: #000; }

    .product-link small { 
      font-family: 'Poppins', sans-serif;
      font-size: 14px; 
      font-weight: 400; 
      color: #6c757d;
    }

    /* SEARCH BOX RESULTS */
    #search-results {
      max-height: 300px;
      overflow-y: auto;
      display: none;
    }

    @media (max-width: 991px) {
      .navbar .d-flex { flex-direction: column; align-items: stretch; gap: 8px; }
      .navbar .d-flex .form-control { width: 100%; }
      .navbar .btn-custom { width: 100%; }
      .navbar .bi-cart-fill { font-size: 22px; }
      .dropdown-menu { width: 100% !important; padding: 20px; box-shadow: none; max-height: none; }
      .products-grid { grid-template-columns: repeat(2, 1fr); gap: 15px; }
    }
  </style>
</head>
<body>

<div class="top-bar-warning">
  <span>WARNING: Vaping products contain nicotine, a highly addictive chemical. - Health Canada</span>
</div>
<div class="top-bar-info">
  SAME DAY DELIVERY FOR GTA - 7DAYS/WEEK - CUT OFF 3PM IN WEEKDAYS & 1 PM IN WEEKENDS
</div>

<div class="logo-section d-none d-lg-block">
  <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo">
</div>

<nav class="navbar navbar-expand-lg" style="padding:0px">
  <div class="container">
    <a class="navbar-brand d-block d-lg-none" href="/" style="padding:0px">
      <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="max-height:70px;">
    </a>
    <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="mainNavbar" style="box-shadow: 0 -6px 6px -4px rgba(0,0,0,0.3); border-radius: 6px;">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="/">HOME</a></li>

        <li class="nav-item dropdown">
          <a class="nav-link" href="/disposibles" id="disposiblesDropdown">DISPOSABLES</a>
          <ul class="dropdown-menu" id="disposiblesMenu"></ul>
        </li>

        <li class="nav-item dropdown">
          <a class="nav-link" href="/vapepods" id="vapepodsDropdown">VAPE PODS</a>
          <ul class="dropdown-menu" id="vapepodsMenu"></ul>
        </li>

        <li class="nav-item dropdown">
          <a class="nav-link" href="/heat" id="hardwareDropdown">HARDWARE</a>
          <ul class="dropdown-menu" id="hardwareMenu"></ul>
        </li>

        <li class="nav-item dropdown">
          <a class="nav-link" href="/liquid" id="liquidDropdown">E-LIQUID</a>
          <ul class="dropdown-menu" id="liquidMenu"></ul>
        </li>

        <li class="nav-item"><a class="nav-link" href="/contactus">CONTACT</a></li>
      </ul>

      <div class="d-flex align-items-center ms-lg-auto mt-3 mt-lg-0">
        <div class="position-relative w-100 me-3">
          <input type="text" id="search-box" class="form-control" placeholder="Search...">
          <div id="search-results" class="list-group position-absolute w-100" style="z-index: 1000;"></div>
        </div>
        <a href="/cart" class="text-dark fs-5 me-3 ms-2"><i class="bi bi-cart-fill"></i></a>
        <a href="/login" class="btn-custom"><i class="bi bi-box-arrow-in-right me-1"></i></a>
        <a href="/register" class="btn-custom"><i class="bi bi-person-plus-fill me-1"></i></a>
      </div>
    </div>
  </div>
</nav>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function () {
  let loadedCategories = {};
  let hideTimeout;

  // LOAD PRODUCTS FOR DROPDOWN
  function loadProducts(category, menuId) {
    if (loadedCategories[category]) return;

    let menu = $("#" + menuId);
    menu.html('<li><span class="dropdown-item loading-text">Loading...</span></li>');

    $.ajax({
      url: "/category-products/" + category,
      type: "GET",
      success: function (data) {
        menu.empty();
        if (data.length > 0) {
          let gridContainer = $('<div class="container-fluid"><div class="products-grid"></div></div>');
          data.forEach(function (product) {
            let productItem = `
              <div class="product-item">
                <a class="product-link" href="/product_details/${product.id}">
                  ${product.name}
                  ${product.price ? `<br><small>$${product.price}</small>` : ""}
                </a>
              </div>
            `;
            gridContainer.find(".products-grid").append(productItem);
          });
          menu.append(gridContainer);
        } else {
          menu.append('<div class="empty-text">No products found</div>');
        }
        loadedCategories[category] = true;
      },
      error: function () {
        menu.empty().append('<div class="empty-text">Error loading products</div>');
      },
    });
  }

  // DROPDOWN HOVER
  $(".dropdown").hover(
    function () {
      clearTimeout(hideTimeout);
      $(".dropdown-menu").stop(true, true).fadeOut(0);
      const category = $(this).find("a").attr("id").replace("Dropdown", "").toLowerCase();
      const menuId = category + "Menu";
      loadProducts(category, menuId);
      $(this).find(".dropdown-menu").stop(true, true).fadeIn(200);
    },
    function () {
      let menu = $(this).find(".dropdown-menu");
      hideTimeout = setTimeout(() => {
        if (!menu.is(":hover") && !$(this).is(":hover")) {
          menu.stop(true, true).fadeOut(200);
        }
      }, 400);
    }
  );

  $(".dropdown-menu").hover(
    function () { clearTimeout(hideTimeout); },
    function () {
      let self = $(this);
      hideTimeout = setTimeout(() => {
        if (!self.is(":hover") && !self.closest(".dropdown").is(":hover")) {
          self.stop(true, true).fadeOut(200);
        }
      }, 400);
    }
  );

  // SEARCH AJAX
  $("#search-box").on("keyup", function () {
    let query = $(this).val().trim();
    if (query.length < 2) {
      $("#search-results").hide().empty();
      return;
    }
    $.ajax({
      url: "/search-products",
      type: "GET",
      data: { q: query },
      success: function (data) {
        let resultsBox = $("#search-results");
        resultsBox.empty().show();
        if (data.length > 0) {
          data.forEach(function (item) {
            let resultItem = `
              <a href="/product_details/${item.id}" 
                 class="list-group-item list-group-item-action">
                ${item.name} 
                ${item.price ? `<small class="text-success"> - $${item.price}</small>` : ""}
              </a>
            `;
            resultsBox.append(resultItem);
          });
        } else {
          resultsBox.append('<div class="list-group-item">No results found</div>');
        }
      },
      error: function () {
        $("#search-results").hide().empty();
      }
    });
  });

  // CLOSE SEARCH RESULTS OUTSIDE CLICK
  $(document).on("click", function (e) {
    if (!$(e.target).closest("#search-box, #search-results").length) {
      $("#search-results").hide();
    }
  });
});
</script>

</body>
</html>
<?php /**PATH F:\captain vape\perfum_project\myapp\resources\views/header.blade.php ENDPATH**/ ?>