
@if(session('success'))
    <script>
        alert("{{ session('success') }}");
    </script>
@endif

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.jpg') }}" rel="icon">


  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <!--<link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">-->
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">
 
  
  <!-- CSS for Larger Floating WhatsApp Button -->
 
<!-- Overlay -->



<!-- Age Verification Modal -->
<div class="modal fade" id="ageVerificationModal" tabindex="-1" aria-labelledby="ageVerificationLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header border-0">
        <h5 class="modal-title" id="ageVerificationLabel" style="color: #d4af37; font-weight: 700;">Age Verification</h5>
      </div>
      <div class="modal-body text-center">
        <img src="{{ asset('assets/logo.png') }}" alt="Captain Vape" style="height: 80px; margin-bottom: 20px;">
        <h4 style="color: #333; margin-bottom: 20px;">Are you 19 years or older?</h4>
        <p style="color: #666; margin-bottom: 30px;">
          By entering this site, you certify that you are of legal smoking age in your province/state.
        </p>
        <div class="d-flex justify-content-center gap-3">
          <button id="confirmAge" class="btn btn-success px-4 py-2" style="background-color: #d4af37; border: none; min-width: 120px;">
            Yes, I'm 19+
          </button>
          <button id="denyAge" class="btn btn-danger px-4 py-2" style="background-color: #dc3545; border: none; min-width: 120px;">
            No, I'm Underage
          </button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Underage Warning Modal -->
<div class="modal fade" id="underageModal" tabindex="-1" aria-labelledby="underageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header border-0">
        <h5 class="modal-title" id="underageModalLabel" style="color: #dc3545; font-weight: 700;">Access Denied</h5>
      </div>
      <div class="modal-body text-center">
        <i class="bi bi-exclamation-triangle-fill text-danger" style="font-size: 3rem;"></i>
        <h4 class="mt-3" style="color: #333;">You must be 19+ to enter</h4>
        <p class="mt-3" style="color: #666;">
          Our products are intended for adults of legal smoking age only.
        </p>
      </div>
      <div class="modal-footer border-0 justify-content-center">
        <button type="button" class="btn btn-secondary" onclick="redirectToExit()">Exit Site</button>
      </div>
    </div>
  </div>
</div>

<script>
// Show age verification modal on page load
document.addEventListener('DOMContentLoaded', function() {
  // Check if age is already verified
  if(localStorage.getItem('ageVerified') !== 'true') {
    var ageModal = new bootstrap.Modal(document.getElementById('ageVerificationModal'));
    ageModal.show();
  }
  
  // Handle age confirmation
  document.getElementById('confirmAge').addEventListener('click', function() {
    localStorage.setItem('ageVerified', 'true');
    var ageModal = bootstrap.Modal.getInstance(document.getElementById('ageVerificationModal'));
    ageModal.hide();
  });
  
  // Handle underage response
  document.getElementById('denyAge').addEventListener('click', function() {
    var ageModal = bootstrap.Modal.getInstance(document.getElementById('ageVerificationModal'));
    ageModal.hide();
    
    var underageModal = new bootstrap.Modal(document.getElementById('underageModal'));
    underageModal.show();
  });
});

function redirectToExit() {
  // Redirect to a safe site (like google) if user is underage
  window.location.href = 'https://www.google.com';
}

// Optional: Clear verification after some time (e.g., 24 hours)
setTimeout(function() {
  localStorage.removeItem('ageVerified');
}, 24 * 60 * 60 * 1000);
</script>

<style>
/* Custom modal styling */
#ageVerificationModal .modal-content {
  border-radius: 15px;
  border: 2px solid #d4af37;
}

#underageModal .modal-content {
  border-radius: 15px;
  border: 2px solid #dc3545;
}

.modal-backdrop.show {
  opacity: 0.9;
  background-color: #000;
}

/* Disable scrolling when modal is open */
body.modal-open {
  overflow: hidden;
}
</style>

<!-- Top Bar -->
<!-- Top Bar -->


@include('header')


<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');

.header {
  box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);
  z-index: 1030;
  font-family: 'Poppins', sans-serif;
  background: #fff;
}

.topbar {
  border-bottom: 1px solid #eee;
}

.nav-link {
  color: #222 !important;
  padding: 10px 15px !important;
  font-weight: 500;
  font-size: 15px;
  letter-spacing: 0.5px;
  position: relative;
  white-space: nowrap;
  transition: color 0.3s ease;
}

.nav-link:hover,
.nav-link.active {
  color: #d4af37 !important;
}

.nav-link::after {
  content: "";
  position: absolute;
  width: 0;
  height: 2px;
  background: #d4af37;
  left: 0;
  bottom: 0;
  transition: width 0.3s ease;
}

.nav-link:hover::after,
.nav-link.active::after {
  width: 100%;
}

.cart-icon .bi-cart3 {
  font-size: 1.4rem;
  color: #222;
}

/* Mobile Styles */
@media (max-width: 767.98px) {
  .topbar {
    flex-wrap: wrap;
    justify-content: flex-start !important;
  }

  .logo {
    order: 0 !important;
    margin-right: auto !important;
  }

  .flex-wrap-mobile {
    order: 1;
    flex: 1;
    justify-content: space-between !important;
  }

  .navbar-nav {
    background: #fff;
  }

  .nav-item {
    width: 100%;
    text-align: center;
  }

  .nav-link {
    padding: 12px 15px !important;
    border-top: 1px solid #eee;
  }

  .cart-icon {
    display: none !important;
  }

  #searchInput {
    width: 100% !important;
  }
}
</style>


  <main class="main">

   
<section id="hero-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000" style="padding-top: 0px; padding-bottom:0px">
  <div class="carousel-inner">

    <!-- Slide 1 -->
    <div class="carousel-item active" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/main.jpg') }}" style="height:600px; object-fit:cover;" class="d-block w-100" alt="Captain Vape Premium Collection">

        <!-- Text Overlay -->
        <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
             style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
                    background: rgba(0, 0, 0, 0.35);">
          <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
            Captain Vape
          </h1>
          <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
            Premium Disposable Vapes & Flavors – Experience the Taste of Luxury
          </p>
          <a href="/disposibles" 
             class="btn btn-lg mt-3"
             style="background-color: #d4af37; color: #000; border: none; padding: 12px 35px; font-weight: 600; border-radius: 30px;">
            Shop Now
          </a>
        </div>
      </div>
    </div>

    <!-- Slide 2 -->
    <div class="carousel-item" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/main2.jpg') }}" style="height:600px; object-fit:cover;" class="d-block w-100" alt="Captain Vape Premium Pods">

        <!-- Text Overlay -->
        <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
             style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
                    background: rgba(0, 0, 0, 0.35);">
          <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
            Discover Vape Pods
          </h1>
          <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
            Smooth Nicotine Delivery & Premium Vape Hardware
          </p>
          <a href="/vapepods" 
             class="btn btn-lg mt-3"
             style="background-color: #d4af37; color: #000; border: none; padding: 12px 35px; font-weight: 600; border-radius: 30px;">
            Explore Pods
          </a>
        </div>
      </div>
    </div>

  </div>

  <!-- Controls -->
  <button class="carousel-control-prev" type="button" data-bs-target="#hero-carousel" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
  </button>
  <button class="carousel-control-next" type="button" data-bs-target="#hero-carousel" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
  </button>

  <!-- Indicators -->
  <div class="carousel-indicators">
    <button type="button" data-bs-target="#hero-carousel" data-bs-slide-to="0" class="active"></button>
    <button type="button" data-bs-target="#hero-carousel" data-bs-slide-to="1"></button>
  </div>
</section>


<!-- Shipping Policy Section -->
<section class="py-5" style="background-color: #f9f9f9; font-family: 'Poppins', sans-serif;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-10">

        <!-- Page Title -->
        <h1 class="mb-4 fw-bold text-center" style="color: #d4af37; font-size: 2.5rem;">
          Shipping Policy
        </h1>
        <p class="text-center mb-5 text-muted">
          Last Updated: January 2025
        </p>

        <!-- Content -->
        <div class="card shadow-sm border-0 rounded-3 p-4">
          <div class="card-body">

            <h4 class="fw-bold mb-3" style="color:#333;">1. Processing Time</h4>
            <p class="mb-4 text-muted">
              All orders are processed within <strong>1-2 business days</strong>. Orders placed on weekends or holidays will be processed on the next business day.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">2. Shipping Methods</h4>
            <p class="mb-4 text-muted">
              We use reliable shipping carriers to ensure your order is delivered safely and on time. Standard and expedited shipping options are available at checkout.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">3. Shipping Rates</h4>
            <p class="mb-4 text-muted">
              Shipping costs are calculated at checkout based on your location and selected shipping method. 
              Free shipping may be available for orders over a certain amount (when applicable).
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">4. Delivery Estimates</h4>
            <p class="mb-4 text-muted">
              Standard delivery typically takes <strong>3-7 business days</strong>, depending on your location. 
              Please note that delivery times are estimates and may vary due to carrier delays or external factors.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">5. Order Tracking</h4>
            <p class="mb-4 text-muted">
              Once your order has shipped, you will receive an email with tracking information so you can monitor your package in real-time.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">6. International Shipping</h4>
            <p class="mb-4 text-muted">
              At this time, we only ship within Canada. International shipping may be introduced in the future.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">7. Damaged or Lost Packages</h4>
            <p class="mb-4 text-muted">
              If your order arrives damaged or is lost in transit, please contact us immediately. We will work with the shipping carrier to resolve the issue as quickly as possible.
            </p>

            <h4 class="fw-bold mb-3" style="color:#333;">8. Contact Us</h4>
            <p class="mb-0 text-muted">
              For questions about our Shipping Policy, please contact us at:
            </p>
            <p class="fw-semibold mt-2">
              📧 Email: <a href="mailto:mycaptainvape@gmail.com" class="text-dark">mycaptainvape@gmail.com</a><br>
              📍 Address: 104 Dundas St E, Toronto, ON M5B 1C9<br>
              📞 Phone: 416-602-1090
            </p>

          </div>
        </div>

      </div>
    </div>
  </div>
</section>





  </main>  


<!-- Footer Section -->
<footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>

<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">




  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <!--<script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>-->
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->

  

</body>

</html>