@if(session('success'))
<script>
    alert("{{ session('success') }}");
</script>
@endif
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.png') }}" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-pVrmAqHnV5v4RszFqV0XQvQn7o3b1n6oGv8y2rYqYVf8z8+Y6v9h3UOZ9zW9nGZrJ3VJ9oS3/1N6jL1d6x9Ypg==" crossorigin="anonymous" referrerpolicy="no-referrer" />


  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">

  

  @include('header')

 <main class="main">
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row g-5">
                <!-- Product Image Gallery -->
                <div class="col-lg-6">
                    <div class="border rounded-3 overflow-hidden" style="">
                        <img src="{{ asset($product->image) }}" alt="{{ $product->name }}" class="img-fluid w-100 main-image" style="object-fit: contain; height: 400px;">
                    </div>
                    <div class="d-flex mt-3">
                        <div class="thumbnail me-2 border rounded-2 p-1 cursor-pointer" style="width: 80px; border-color: #D4AF37 !important;">
                            <img src="{{ asset($product->image) }}" class="img-fluid" alt="Thumbnail 1">
                        </div>
                        @if(isset($product->second_image))
                        <div class="thumbnail me-2 border rounded-2 p-1 cursor-pointer" style="width: 80px; border-color: #D4AF37 !important;">
                          <img src="{{ asset($product->second_image) }}" class="img-fluid" alt="Thumbnail 2">
                      </div>
                      @endif
                    </div>
                </div>
    
                <!-- Product Details -->
                <div class="col-lg-6">
                    <div class="product-details p-4 rounded-3 shadow-sm" style="background-color: #fff; border: 1px solid #D4AF37;">
                        <h1 class="fw-bold mb-3" style="color: black;">{{ $product->name }}</h1>
                        
                        <div class="d-flex align-items-center mb-3">
                            <div class="rating me-3">
                                <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                <i class="bi bi-star-half" style="color: #D4AF37;"></i>
                            </div>
                            <span class="badge" style="background-color: #D4AF37;">In Stock</span>
                        </div>
    
                        <h3 class="fw-bold mb-4" style="color: black;">$ {{($product->price) }}</h3>
    
                      
    
                        <div class="features mb-4">
                          <h5 class="fw-bold " style="color: black;">Key Features:</h5>
                           <p class="text-muted">{{ $product->description }}</p>
                      </div>
    
                        <div class="d-flex align-items-center mb-4">
                           
                            <form action="{{ route('cart.add') }}" method="POST" class="w-100">
                                @csrf
                              
                                <input type="hidden" name="product_id" value="{{ $product->id }}">
                                <input type="hidden" name="quantity" value="1" id="quantity-input">
                                <button type="submit" class="btn btn-lg w-100 py-2" style="margin-top:80px; background-color: #fec630; color: black;">
                                    <i class="bi bi-cart-plus me-2"></i> Add to Cart
                                </button>
                            </form>
                        </div>
    
                        <div class="d-flex border-top pt-3" style="border-color: #D4AF37 !important;">
                            <div class="me-4">
                                <i class="bi bi-truck fs-4" style="color: black;"></i>
                                <span class="d-block small">Free Delivery</span>
                            </div>
                            <div class="me-4">
                                <i class="bi bi-arrow-repeat fs-4" style="color: #lack;"></i>
                                <span class="d-block small">30 Day Returns</span>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
    
            <!-- Product Description Tabs -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="card border-0 shadow-sm" style="border-color: #D4AF37 !important;">
                        <div class="card-body">
                            <ul class="nav nav-tabs mb-4" id="productTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="description-tab" data-bs-toggle="tab" data-bs-target="#description" type="button" role="tab" style="color: #996515; border-bottom: 2px solid #D4AF37;">Description</button>
                                </li>
                            </ul>
                            <div class="tab-content" id="productTabsContent">
                                <div class="tab-pane fade show active" id="description" role="tabpanel">
                                    <p>{{ $product->description }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <style>
        .product-details {
            position: sticky;
            top: 20px;
        }
        .thumbnail {
            transition: all 0.3s;
        }
        .thumbnail:hover {
            border-color: #D4AF37 !important;
            transform: scale(1.05);
        }
        .nav-tabs .nav-link {
            color: #996515;
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            color: #996515;
            border-bottom: 2px solid #D4AF37;
        }
        .quantity input {
            -moz-appearance: textfield;
        }
        .quantity input::-webkit-outer-spin-button,
        .quantity input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        .btn-outline-secondary:hover {
            background-color: #D4AF37;
            color: white;
        }
        .form-select:focus {
            border-color: #D4AF37;
            box-shadow: 0 0 0 0.25rem rgba(212, 175, 55, 0.25);
        }
    </style>
    
    <script>
        document.querySelector('.increment').addEventListener('click', function() {
            const input = this.parentNode.querySelector('input');
            input.value = parseInt(input.value) + 1;
        });
        
        document.querySelector('.decrement').addEventListener('click', function() {
            const input = this.parentNode.querySelector('input');
            if (parseInt(input.value) > 1) {
                input.value = parseInt(input.value) - 1;
            }
        });
        
        document.querySelectorAll('.thumbnail img').forEach(thumb => {
            thumb.addEventListener('click', function() {
                document.querySelector('.main-image').src = this.src;
            });
        });
    </script>
</main>


<footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>
   
  
  

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
  

</body>

</html>