<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Login</title>
    <style>
      /* Base Styles */
      * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
      }
      
      body {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        background: #f8fafc;
        padding: 1rem;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
      }
      
      .login-container {
        width: 100%;
        max-width: 400px;
        margin: auto;
        padding: 1.5rem;
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      }
      
      .login-header {
        text-align: center;
        margin-bottom: 1.5rem;
      }
      
      .login-icon {
        width: 42px;
        height: 42px;
        margin: 0 auto 0.75rem;
        display: block;
      }
      
      .login-header h1 {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 0.5rem;
      }
      
      .login-header p {
        color: #666;
        font-size: 0.9rem;
      }
      
      .status-message {
        padding: 0.75rem;
        background: #f0fdf4;
        color: #166534;
        border-radius: 8px;
        margin-bottom: 1.25rem;
        font-size: 0.85rem;
        display: none;
      }
      
      .login-form {
        display: flex;
        flex-direction: column;
        gap: 1.25rem;
      }
      
      .form-group {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
      }
      
      .form-group label {
        font-size: 0.85rem;
        font-weight: 500;
        color: #333;
      }
      
      .label-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
      }
      
      .forgot-password {
        font-size: 0.8rem;
        color: #4f46e5;
        text-decoration: none;
        font-weight: 500;
      }
      
      .input-wrapper {
        position: relative;
        display: flex;
        align-items: center;
      }
      
      .input-icon {
        position: absolute;
        left: 12px;
        width: 16px;
        height: 16px;
        color: #999;
      }
      
      .show-password {
        position: absolute;
        right: 12px;
        background: none;
        border: none;
        cursor: pointer;
        color: #999;
        padding: 0;
        width: 18px;
        height: 18px;
      }
      
      input {
        width: 100%;
        padding: 0.75rem 1rem 0.75rem 36px;
        border: 1px solid #ddd;
        border-radius: 8px;
        font-size: 0.9rem;
        transition: all 0.2s;
      }
      
      input:focus {
        outline: none;
        border-color: #4f46e5;
        box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.2);
      }
      
      .error-message {
        font-size: 0.75rem;
        color: #dc2626;
        min-height: 1rem;
        display: none;
      }
      
      .remember-me {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.85rem;
        color: #555;
      }
      
      .remember-me input {
        width: auto;
        padding: 0;
        margin: 0;
      }
      
      .login-button {
        background: #4f46e5;
        color: white;
        border: none;
        padding: 0.75rem;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.9rem;
        cursor: pointer;
        transition: background 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
      }
      
      .login-button:hover {
        background: #4338ca;
      }
      
      .login-button svg {
        width: 16px;
        height: 16px;
      }
      
      .signup-link {
        text-align: center;
        margin-top: 1.25rem;
        font-size: 0.85rem;
        color: #666;
      }
      
      .signup-link a {
        color: #4f46e5;
        font-weight: 500;
        text-decoration: none;
      }

      /* Google Sign-In Button */
      .google-signin {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.75rem;
        width: 100%;
        padding: 0.75rem;
        background: white;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.9rem;
        color: #3c4043;
        cursor: pointer;
        transition: all 0.2s;
        margin-top: 0.5rem;
      }
      
      .google-signin:hover {
        background: #f9fafb;
        border-color: #9ca3af;
      }
      
      .google-signin:active {
        background: #f3f4f6;
      }
      
      .google-icon {
        width: 18px;
        height: 18px;
      }
      
      /* Divider */
      .divider {
        display: flex;
        align-items: center;
        margin: 1.25rem 0;
        color: #9ca3af;
        font-size: 0.8rem;
      }
      
      .divider::before,
      .divider::after {
        content: "";
        flex: 1;
        border-bottom: 1px solid #e5e7eb;
      }
      
      .divider::before {
        margin-right: 0.75rem;
      }
      
      .divider::after {
        margin-left: 0.75rem;
      }
      
      /* Dark Mode */
      @media (prefers-color-scheme: dark) {
        body {
          background: #111827;
        }
        
        .login-container {
          background: #1e1e2d;
          box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }
        
        .login-header h1 {
          color: #f3f4f6;
        }
        
        .login-header p {
          color: #9ca3af;
        }
        
        input {
          background: #2d3748;
          border-color: #4b5563;
          color: white;
        }
        
        .input-icon, .show-password {
          color: #6b7280;
        }
        
        .form-group label {
          color: #e5e7eb;
        }
        
        .signup-link {
          color: #9ca3af;
        }
        
        .remember-me {
          color: #d1d5db;
        }
        
        .google-signin {
          background: #2d3748;
          border-color: #4b5563;
          color: #f3f4f6;
        }
        
        .google-signin:hover {
          background: #374151;
          border-color: #6b7280;
        }
        
        .divider {
          color: #6b7280;
        }
        
        .divider::before,
        .divider::after {
          border-bottom-color: #4b5563;
        }
      }
      
      /* Tablet and Desktop */
      @media (min-width: 640px) {
        .login-container {
          padding: 2rem 2.5rem;
        }
        
        .login-header h1 {
          font-size: 1.75rem;
        }
        
        .login-icon {
          width: 48px;
          height: 48px;
        }
        
        input {
          padding: 0.75rem 1rem 0.75rem 40px;
          font-size: 0.95rem;
        }
        
        .input-icon {
          width: 18px;
          height: 18px;
        }
      }
      
      /* Small Mobile Devices */
      @media (max-width: 360px) {
        .login-container {
          padding: 1.25rem;
          border-radius: 12px;
        }
        
        .login-header h1 {
          font-size: 1.3rem;
        }
        
        input {
          padding: 0.65rem 0.9rem 0.65rem 34px;
        }
        
        .login-button {
          padding: 0.65rem;
        }
      }
    </style>
</head>
<body>
    
    <div class="login-container">
        <!-- Header Section -->
        <div class="login-header">
          <svg class="login-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 12C14.7614 12 17 9.76142 17 7C17 4.23858 14.7614 2 12 2C9.23858 2 7 4.23858 7 7C7 9.76142 9.23858 12 12 12Z" fill="#4F46E5"/>
            <path d="M12 14C7.58172 14 4 17.5817 4 22H20C20 17.5817 16.4183 14 12 14Z" fill="#4F46E5"/>
          </svg>
          <h1>Captain vape</h1>
          <p>Sign in to access your account</p>
        </div>
      
        <!-- Status Messages -->
        <div class="status-message">
          [Status messages will appear here]
        </div>
      
        <!-- Login Form -->
        <form method="POST" action="{{ route('login') }}" class="login-form">
          @csrf
          
          <!-- Email Field -->
          <div class="form-group">
            <label for="email">Email Address</label>
            <div class="input-wrapper">
              <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
              </svg>
              <input 
                id="email"
                type="email"
                name="email"
                placeholder="your@email.com"
                required
                autofocus
                autocomplete="username"
              />
            </div>
            <div class="error-message">[Email errors appear here]</div>
          </div>
          
          <!-- Password Field -->
          <div class="form-group">
            <div class="label-row">
              <label for="password">Password</label>
              <a href="{{ route('password.request') }}" class="forgot-password">Forgot password?</a>
            </div>
            <div class="input-wrapper">
              <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
              </svg>
              <input
                id="password"
                type="password"
                name="password"
                placeholder="••••••••"
                required
                autocomplete="current-password"
              />
              <button type="button" class="show-password" aria-label="Show password">
                <svg viewBox="0 0 20 20" fill="currentColor">
                  <path d="M10 12a2 2 0 100-4 2 2 0 000 4z"/>
                  <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd"/>
                </svg>
              </button>
            </div>
            <div class="error-message">[Password errors appear here]</div>
          </div>
          
          <!-- Remember Me -->
          <div class="remember-me">
            <input type="checkbox" id="remember_me" name="remember">
            <label for="remember_me">Remember me</label>
          </div>
          
          <!-- Submit Button -->
          <button type="submit" class="login-button">
            Sign In
            <svg viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
            </svg>
          </button>
        </form>
        
        <!-- Divider -->
        <div class="divider">or</div>
        
        <!-- Google Sign-In Button -->
        <a href="{{ route('google.login') }}" class="google-signin">
          <svg class="google-icon" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" fill="#4285F4"/>
            <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" fill="#34A853"/>
            <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" fill="#FBBC05"/>
            <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" fill="#EA4335"/>
          </svg>
          Sign in with Google
        </a>
        
        <!-- Sign Up Link -->
        <div class="signup-link">
          Don't have an account? <a href="{{ route('register') }}">Sign up</a>
        </div>
      </div>
      
      <script>
      // Password visibility toggle
      document.querySelectorAll('.show-password').forEach(button => {
        button.addEventListener('click', (e) => {
          const input = e.currentTarget.parentElement.querySelector('input');
          const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
          input.setAttribute('type', type);
          e.currentTarget.innerHTML = type === 'password' ? 
            `<svg viewBox="0 0 20 20" fill="currentColor">
              <path d="M10 12a2 2 0 100-4 2 2 0 000 4z"/>
              <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd"/>
            </svg>` :
            `<svg viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M3.707 2.293a1 1 0 00-1.414 1.414l14 14a1 1 0 001.414-1.414l-1.473-1.473A10.014 10.014 0 0019.542 10C18.268 5.943 14.478 3 10 3a9.958 9.958 0 00-4.512 1.074l-1.78-1.781zm4.261 4.26l1.514 1.515a2.003 2.003 0 012.45 2.45l1.514 1.514a4 4 0 00-5.478-5.478z" clip-rule="evenodd"/>
              <path d="M12.454 16.697L9.75 13.992a4 4 0 01-3.742-3.741L2.335 6.578A9.98 9.98 0 00.458 10c1.274 4.057 5.065 7 9.542 7 .847 0 1.669-.105 2.454-.303z"/>
            </svg>`;
        });
      });
      </script>
</body>
</html>