<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Perfumes Canada</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.png') }}" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">
  <a href="https://wa.me/+19054679828" class="whatsapp-button" target="_blank" rel="noopener noreferrer">
    <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp Icon">
  </a>
  
  <!-- CSS for Larger Floating WhatsApp Button -->
  <style>
    .whatsapp-button {
      position: fixed;
      bottom: 110px; /* Adjust the distance from the bottom */
      right: 20px; /* Adjust the distance from the right */
      z-index: 1000; /* Ensure it stays on top of other elements */
      background-color: #25d366; /* WhatsApp green color */
      border-radius: 50%; /* Make it circular */
      padding: 15px; /* Increased padding for larger size */
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2); /* Add a subtle shadow */
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
  
    .whatsapp-button:hover {
      transform: scale(1.1); /* Slightly enlarge on hover */
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3); /* Enhance shadow on hover */
    }
  
    .whatsapp-button img {
      display: block;
      width: 60px; /* Increased icon size */
      height: 60px; /* Increased icon size */
    }
  </style>

<header class="header bg-white pb-0">
  <div class="topbar container d-flex justify-content-between align-items-center py-2 px-3">

    <!-- Left: Logo -->
    <a href="/" class="logo">
      <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="height: 70px;">
    </a>

    <!-- Right Side: Search + Cart + Toggler -->






      <!-- Desktop Cart -->
      <div class="d-none d-md-flex align-items-center me-3">
         
           <a href="/" class="position-relative ms-3" style="color: black; text-decoration: none;">
                Welcome To Our Shop
              
            </a>
              <a href="/" class="position-relative ms-3" style="color: white; background:#D4AF37; border-radius:20px;padding:15px; text-decoration: none;">
                104 Dundas St E, Toronto, ON M5B 1C9
              
            </a>
      <a href="/cart" class="position-relative ms-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
      </div>

      <!-- Mobile Cart + Toggler -->
      <div class="d-md-none d-flex align-items-center">
       <a href="/cart" class="position-relative me-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
        <button class="navbar-toggler text-dark border-0 bg-transparent p-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
          <i class="bi bi-list fs-4"></i>
        </button>
      </div>
    </div>
  </div>

  <!-- Navigation -->
  <nav class="navbar navbar-expand-md">
    <div class="container-fluid px-0">
      <div class="collapse navbar-collapse" id="navbarCollapse">
        <ul class="navbar-nav w-100 justify-content-center flex-wrap py-2 m-0">
          <li class="nav-item"><a class="nav-link " href="/">Home</a></li>
       
          <li class="nav-item"><a class="nav-link" href="/disposibles">disposibles</a></li>
          <li class="nav-item"><a class="nav-link" href="/vapepods">Vape Pods</a></li>
          <li class="nav-item"><a class="nav-link" href="/heat">Heat-Not Burn</a></li>
          <li class="nav-item"><a class="nav-link" href="/liquid">E-Liquid</a></li>
          <li class="nav-item"><a class="nav-link" href="/hardware">Hardware</a></li>
          <li class="nav-item"><a class="nav-link" href="/clean">CLearance</a></li>
          <li class="nav-item"><a class="nav-link" href="/contactus">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>
</header>

  <main class="main">

<!-- Hero Section -->
<section id="hero" class="hero-section">
    <div class="hero-container">
      <div class="hero-background">
        <img src="{{asset('assets/images/abf.png')}}" alt="Luxury Perfume Collection" class="hero-image" data-aos="fade-in">
        <div class="overlay"></div>
      </div>
      
      {{-- <div class="hero-content" data-aos="fade-up">
        <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-8 text-center">
                <h1 class="hero-title" data-aos="fade-up" data-aos-delay="100">The Poetry of Femininity</h1>
                <p class="hero-subtitle" data-aos="fade-up" data-aos-delay="150">Scents That Celebrate Womanhood</p>
                <div class="divider" data-aos="fade-up" data-aos-delay="200"></div>
                <p class="hero-description" data-aos="fade-up" data-aos-delay="200">
                  Our women's collection is a symphony of delicate florals, lush fruits, and warm spices - each fragrance 
                  crafted to honor the many facets of femininity. From daytime freshness to evening allure, discover scents 
                  that become extensions of your personality.
                </p>
                <div class="hero-cta" data-aos="fade-up" data-aos-delay="300">
                  <a href="/allproducts" class="btn-explore">Explore Feminine Scents</a>
                  <a href="/about" class="btn-discover ml-3">The Art of Women's Perfumery</a>
                </div>
              </div>
            </div>
          </div>
      </div> --}}
    </div>
  </section>
  
  <style>
  .hero-section {
    padding-top: 0px;
    position: relative;
    height: 100vh;
    min-height: 900px;
    overflow: hidden;
  }
  
  .hero-container {
    position: relative;
    height: 100%;
  }
  
  .hero-background {
    position: absolute;
    width: 100%;
    height: 100%;
  }
  
  .hero-image {
    width: 100%;
    height: 100%;
    /* object-fit: cover; */
  }
  
  .overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    /* background: rgba(0, 0, 0, 0.3);
    background: linear-gradient(135deg, rgba(10, 5, 30, 0.6) 0%, rgba(80, 30, 80, 0.3) 100%); */
  }
  
  .hero-content {
    position: relative;
    z-index: 2;
    display: flex;
    align-items: center;
    height: 100%;
    color: #fff;
    text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
  }
  
  .hero-title {
    font-size: 4rem;
    font-weight: 300;
    letter-spacing: 2px;
    margin-bottom: 0.5rem;
    color: white;
    text-transform: uppercase;
  }
  
  .hero-subtitle {
    font-size: 1.5rem;
    font-weight: 300;
    letter-spacing: 4px;
    margin-bottom: 1.5rem;
  }
  
  .divider {
    width: 80px;
    height: 2px;
    background: #fff;
    margin: 1.5rem auto;
    opacity: 0.7;
  }
  
  .hero-description {
    font-size: 1.1rem;
    max-width: 700px;
    margin: 0 auto 2rem;
    line-height: 1.8;
    opacity: 0.9;
  }
  
  .btn-explore, .btn-discover {
    padding: 12px 30px;
    border-radius: 30px;
    font-weight: 500;
    letter-spacing: 1px;
    text-transform: uppercase;
    transition: all 0.3s ease;
  }
  
  .btn-explore {
    background: #fff;
    color: #3a0a3a;
    border: 2px solid #fff;
  }
  
  .btn-explore:hover {
    background: transparent;
    color: #fff;
  }
  
  .btn-discover {
    background: transparent;
    color: #fff;
    border: 2px solid #fff;
  }
  
  .btn-discover:hover {
    background: #fff;
    color: #3a0a3a;
  }
  
  @media (max-width: 768px) {
    .hero-title {
      font-size: 2.5rem;
    }
    
    .hero-subtitle {
      font-size: 1.2rem;
    }
    
    .hero-cta {
      display: flex;
      flex-direction: column;
    }
    
    .btn-discover {
      margin-left: 0 !important;
      margin-top: 15px;
    }
  }
  </style>

 
<!-- Portfolio Section -->
<section id="portfolio" class="portfolio section">
    <div class="container section-title" data-aos="fade-up">
      <h2>After Shaves</h2>
      <p>Discover our latest and most captivating fragrances for women, crafted to elevate your elegance.</p>
      
      <!-- Search Bar -->
      <div class="row justify-content-center mb-5">
        <div class="col-md-6">
          <div class="search-container mt-3">
            <input type="text" id="productSearch" class="form-control search-input" placeholder="Search fragrances...">
            <button class="search-btn">
              <i class="bi bi-search"></i>
            </button>
          </div>
        </div>
      </div>
    </div>
  
    <div class="container">
      <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
        @foreach($products as $product)
        <div class="col-lg-4 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
          <div class="card h-100 product-card border-0 shadow perfume-card">
            <div class="position-relative overflow-hidden rounded-top" style="height: 300px; background: #f8f9fa;">
              <!-- Image Container -->
              <div class="image-container h-100 w-100">
                <a href="{{route('product_details',$product->id)}}" class="d-block h-100 w-100">
                  <!-- Main Image (Always visible) -->
                  <img src="{{ asset($product->image) }}" 
                       class="img-fluid product-image" 
                       alt="{{ $product->name }}"
                       style="width: 100%; height: 100%; object-fit: contain;">
                  
                  <!-- Secondary Image (shown on hover if exists) -->
                  @if($product->second_image)
                  <img src="{{ asset($product->second_image) }}" 
                       class="img-fluid product-image hover-image" 
                       alt="{{ $product->name }} alternate view"
                       style="width: 100%; height: 100%; object-fit: contain;">
                  @endif
                </a>
              </div>
              
              <!-- Wishlist Button -->
              <div class="card-actions position-absolute top-0 end-0 p-2">
                <button class="btn btn-sm btn-light rounded-circle shadow-sm">
                  <i class="bi bi-heart"></i>
                </button>
              </div>
              
              <!-- Discount Badge -->
              @if($product->discount_percent)
              <div class="badge bg-danger position-absolute top-0 start-0 m-2">
                -{{ $product->discount_percent }}%
              </div>
              @endif
            </div>
  
            <div class="card-body text-center">
              <h6 class="card-title mb-2">
                <a href="{{route('product_details',$product->id)}}" class="text-dark text-decoration-none product-name">
                  {{ Str::limit($product->name, 45) }}
                </a>
              </h6>
  
              <!-- Rating -->
              <div class="rating text-warning mb-2">
                <i class="bi bi-star-fill"></i>
                <i class="bi bi-star-fill"></i>
                <i class="bi bi-star-fill"></i>
                <i class="bi bi-star-fill"></i>
                <i class="bi bi-star-half"></i>
              </div>
  
              <!-- Price -->
              <div class="price-container mb-2">
                <span class="text-primary fw-bold">${{ number_format($product->price, 2) }}</span>
                @if($product->previous_price)
                <small class="text-muted text-decoration-line-through ms-1">${{ number_format($product->previous_price, 2) }}</small>
                @endif
              </div>
  
              <!-- View Button -->
              <a href="{{route('product_details',$product->id)}}" class="btn btn-outline-dark btn-sm rounded-pill px-3">
                View Details
              </a>
            </div>
          </div>
        </div>
        @endforeach

        <div id="noProductsFound" class="col-12 text-center py-5" style="display: none;">
            <i class="bi bi-search display-4 text-muted mb-3"></i>
            <h4 class="text-muted">No fragrances found</h4>
            <p class="text-muted">Try adjusting your search or browse our collection</p>
            <a href="{{ url()->current() }}" class="btn btn-outline-primary mt-3">
              <i class="bi bi-arrow-counterclockwise"></i> Reset Search
            </a>
          </div>
      </div>
    </div>
  </section>
  
  <style>
    /* Search Bar Styling */
    .search-container {
      position: relative;
      width: 100%;
    }
    
    .search-input {
      padding: 12px 20px;
      border-radius: 50px;
      border: 1px solid #ddd;
      width: 100%;
      font-size: 1rem;
      transition: all 0.3s ease;
      padding-right: 50px;
    }
    
    .search-input:focus {
      border-color: #d63384;
      box-shadow: 0 0 0 3px rgba(214, 51, 132, 0.2);
      outline: none;
    }
    
    .search-btn {
      position: absolute;
      right: 5px;
      top: 50%;
      transform: translateY(-50%);
      background: transparent;
      border: none;
      color: #d63384;
      font-size: 1.2rem;
      padding: 8px 15px;
      cursor: pointer;
    }
    
    /* Product Card Styling */
    .product-card {
      transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
      border-radius: 12px;
      overflow: hidden;
      border: 1px solid rgba(0,0,0,0.05);
    }
    
    .product-card:hover {
      transform: translateY(-10px) scale(1.02);
      box-shadow: 0 15px 30px rgba(0,0,0,0.15) !important;
    }
    
    .image-container {
      position: relative;
      overflow: hidden;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .product-image {
      transition: all 0.5s ease;
      position: absolute;
      width: 100%;
      height: 100%;
      object-fit: contain;
      padding: 20px;
    }
    
    .hover-image {
      opacity: 0;
    }
    
    .product-card:hover .product-image:not(.hover-image) {
      opacity: 0;
      transform: scale(0.95);
    }
    
    .product-card:hover .hover-image {
      opacity: 1;
      transform: scale(1);
    }
    
    /* If no second image, keep main image visible on hover */
    .product-card:not(:has(.hover-image)):hover .product-image {
      opacity: 1 !important;
      transform: scale(1.05) !important;
    }
    
    /* Rest of your existing styles... */
  </style>
  
  

<script>
document.addEventListener('DOMContentLoaded', function() {
  const searchInput = document.getElementById('productSearch');
  const productItems = document.querySelectorAll('.product-item');
  const noProductsFound = document.getElementById('noProductsFound');
  const productsContainer = document.getElementById('productsContainer');
  
  searchInput.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    let visibleItems = 0;
    
    productItems.forEach(item => {
      const productName = item.dataset.name;
      if (productName.includes(searchTerm)) {
        item.style.display = 'block';
        visibleItems++;
      } else {
        item.style.display = 'none';
      }
    });
    
    // Show/hide no products message
    if (searchTerm && visibleItems === 0) {
      noProductsFound.style.display = 'block';
    } else {
      noProductsFound.style.display = 'none';
    }
  });
  
  // Rest of your existing JavaScript...
});
</script>

<style>
  /* Add to your existing styles */
  #noProductsFound {
    background: #f8f9fa;
    border-radius: 10px;
    margin-top: 20px;
  }
  
  .search-btn:hover {
    color: #b02a37;
  }
</style>
    <script>
    // Initialize hover effects
    const productCards = document.querySelectorAll('.product-card');
    productCards.forEach(card => {
      const hasHoverImage = card.querySelector('.hover-image') !== null;
      
      if (!hasHoverImage) {
        const mainImage = card.querySelector('.product-image');
        card.addEventListener('mouseenter', () => {
          mainImage.style.transform = 'scale(1.05)';
        });
        card.addEventListener('mouseleave', () => {
          mainImage.style.transform = 'scale(1)';
        });
      }
    });
</script>

    <!-- Services Section -->
  

    <section id="contact" class="contact section">

      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <h2>Contact</h2>
        <p>Contact Us </p>
      </div><!-- End Section Title -->

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-4">
          <div class="col-lg-6 ">
            <div class="row gy-4">

              <div class="col-lg-12">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="200">
                  <i class="bi bi-geo-alt"></i>
                  <h3>Address</h3>
                  <p> Bramtpon , ON </p>
                </div>
              </div><!-- End Info Item -->

              <div class="col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="300">
                  <i class="bi bi-telephone"></i>
                  <h3>Call Us</h3>
                  <p>+1 905-467-9828</p>
                </div>
              </div><!-- End Info Item -->

              <div class="col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="400">
                  <i class="bi bi-envelope"></i>
                  <h3>Email Us</h3>
                  <p> info@perfumescanada.com </p>
                </div>
              </div><!-- End Info Item -->

            </div>
          </div>

          <div class="col-lg-6">
            <form action="{{route('contact_form')}}" method="POST"  data-aos="fade-up" data-aos-delay="500">
              @csrf
              <div class="row gy-4">

                <div class="col-md-6">
                  <input type="text" name="name" class="form-control" placeholder="Your Name" required="">
                </div>

                <div class="col-md-6 ">
                  <input type="email" class="form-control" name="email" placeholder="Your Email" required="">
                </div>

                <div class="col-md-12">
                  <input type="text" class="form-control" name="subject" placeholder="Subject" required="">
                </div>

                <div class="col-md-12">
                  <textarea class="form-control" name="message" rows="4" placeholder="Message" required=""></textarea>
                </div>


                  <button class="btn btn-danger">Send Message</button>
                </div>

              </div>
            </form>
          </div><!-- End Contact Form -->

        </div>

      </div>

    </section><!-- /Contact Section -->
   

  </main>

  <footer id="footer" class="footer dark-background py-5">
    <div class="container footer-top">
      <div class="row gy-4">
  
        <!-- Column 1: About -->
        <div class="col-lg-3 col-md-6 footer-about">
          <a href="/" class="logo d-flex align-items-center mb-2">
            <span class="sitename">Perfumes Canada</span>
          </a>
          <p>Your destination for luxury fragrances, gift sets, and exclusive collections across Canada. Discover your scent today!</p>
          <div class="footer-contact pt-3">
            <p> Bramtpon , ON </p>
            <p class="mt-3"><strong>Phone:</strong> <span>+1 905-467-9828</span></p>
          </div>
        </div>
  
        <!-- Column 2: Links -->
        <div class="col-lg-3 col-md-6 footer-links">
            <h4>Explore</h4>
            <ul>
              <li><a href="/">Home</a></li>
              <li><a href="/">About Us</a></li>
              <li><a href="/men">Mens</a></li>
              <li><a href="/women">Womens</a></li>
              <li><a href="/giftset">Gift Sets</a></li>
              <li><a href="/testors">Testors</a></li>
              <li><a href="{{ route('allproducts') }}">Full Catalog</a></li>
            </ul>
          </div>
  
        <!-- Column 3: Images -->
        <div class="col-lg-3 col-md-6">
          <h4>Our Policies</h4>
          <ul style="list-style:none">
            <li><a href="{{ route('allproducts') }}" style="color: white">Full catalogue</a></li>
            <li><a href="" style="color: white">Women</a></li>
            <li><a href="/men" style="color: white">Mens</a></li>
            <li><a href="/giftset" style="color: white">Gift Sets</a></li>
            <li><a >Privacy Policy</a></li>
            <li><a >Term of Service</a></li>
            <li><a >Refund Policy</a></li>
          </ul>
        </div>
  
        <!-- Column 4: Newsletter -->
        <div class="col-lg-3 col-md-6 footer-newsletter">
            <h4>Our Newsletter</h4>
            <p>Subscribe to our newsletter and receive the latest news about our products and services!</p>
            <div class="container py-4">
              <h5 class="mb-3">We Accept</h5>
              <div class="d-flex flex-wrap align-items-center gap-3">
                <img src="{{ asset('assets/images/visa.jpg') }}" alt="Visa" style="height: 40px;">
                <img src="{{ asset('assets/images/master.png') }}" alt="MasterCard" style="height: 40px;">
                <img src="{{ asset('assets/images/paypal.png') }}" alt="PayPal" style="height: 40px;">
            
              </div>
            </div>
            
          </div>
  
      </div>
    </div>
  
    <div class="container copyright text-center mt-4">
      <p>© <strong class="px-1 sitename">Perfumes Canada</strong> | All Rights Reserved</p>
      <div class="credits">
        Designed by <a href="https://bizzsofts.com/">bizzsofts Development</a>
      </div>
    </div>
  </footer>
  

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
  

</body>

</html>