@extends('admin.master')

@section('main')

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Messages</h2>
        <div class="col-md-4">
            <input type="text" id="searchInput" class="form-control" placeholder="Search by name...">
        </div>
    </div>
    
    <div class="table-responsive">
        <table class="table table-bordered table-hover" id="messagesTable">
            <thead class="thead-dark">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Subject</th>
                    <th>Message</th>
                </tr>
            </thead>
            <tbody id="tableBody">
                @foreach($msg as $item)
                <tr>
                    <td>{{ $loop->iteration}}</td>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->email }}</td>
                    <td>{{ $item->subject }}</td>
                    <td>{{ Str::limit($item->message, 50) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div id="noResults" class="text-center py-4" style="display: none;">
            <i class="bi bi-search display-4 text-muted mb-3"></i>
            <h4 class="text-muted">No messages found</h4>
            {{-- <p class="text-muted">Try adjusting your search query</p> --}}
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const tableBody = document.getElementById('tableBody');
    const rows = tableBody.getElementsByTagName('tr');
    const noResults = document.getElementById('noResults');
    
    searchInput.addEventListener('keyup', function() {
        const searchValue = this.value.toLowerCase();
        let hasResults = false;
        
        for (let i = 0; i < rows.length; i++) {
            const nameCell = rows[i].getElementsByTagName('td')[1]; // Name is in second column
            if (nameCell) {
                const nameText = nameCell.textContent.toLowerCase();
                if (nameText.includes(searchValue)) {
                    rows[i].style.display = '';
                    hasResults = true;
                } else {
                    rows[i].style.display = 'none';
                }
            }
        }
        
        // Show/hide no results message
        if (hasResults || searchValue === '') {
            noResults.style.display = 'none';
            tableBody.style.display = '';
        } else {
            noResults.style.display = 'block';
            tableBody.style.display = 'none';
        }
    });
});
</script>

<style>
    .table-responsive {
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        min-height: 300px;
        position: relative;
    }
    
    .thead-dark {
        background-color: #343a40;
        color: white;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(0,0,0,0.03);
    }
    
    #searchInput {
        border-radius: 20px;
        border: 1px solid #ced4da;
        padding: 8px 15px;
    }
    
    #searchInput:focus {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25);
    }
    
    #noResults {
        background: #f8f9fa;
        border-radius: 8px;
    }
</style>

@endsection