@extends('admin.master')

@section('main')
<div class="container mt-4">
    <div class="card">
        <div class="card-header bg-dark text-white">
            <h4 class="mb-0">Add New Products</h4>
        </div>
        <div class="card-body">
            <form action="{{ isset($product) ? route('update_product', $product->id) : route('add_product') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @if(isset($product))
                    @method('PUT')
                @endif
                <div class="row">
                    <!-- Title -->
                    <div class="col-md-6 pe-md-3">
                        <div class="mb-3">
                            <label for="title" class="form-label">Title</label>
                            <input type="text" name="title" id="title" class="form-control" required 
                                   value="{{ old('name', $product->name ?? '') }}" placeholder="Product title">
                        </div>
            
                        <!-- Price -->
                        <div class="mb-3">
                            <label for="price" class="form-label">Price</label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="text" name="price" id="price" class="form-control" required 
                                       value="{{ old('price', $product->price ?? '') }}" placeholder="Product selling price">
                            </div>
                        </div>
            
                        <!-- Brand -->
                     
                    </div>
            
                    <!-- Right Side -->
                    <div class="col-md-6 ps-md-3">
                        <!-- Previous Price -->
                   
            
                        <!-- Category -->
                        <div class="mb-3">
                            <label for="category" class="form-label">Category</label>
                            <select name="category" id="category" class="form-select" required>
                                <option value="" disabled {{ isset($product) ? '' : 'selected' }}>Select a category</option>
                                @foreach(['disposibles', 'vapepods', 'heat', 'liquid','hardware','clean'] as $cat)
                                    <option value="{{ $cat }}" {{ (old('category', $product->category ?? '') == $cat) ? 'selected' : '' }}>
                                        {{ ucfirst($cat) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
            
                      
            
                        <!-- Image Inputs -->
                        <div class="mb-3">
                            <label for="image" class="form-label">Main Image</label>
                            <input type="file" name="image" id="image" class="form-control" {{ isset($product) ? '' : 'required' }}>
                            @if(isset($product) && $product->image)
                                <img src="{{ asset('uploads/' . $product->image) }}" class="img-thumbnail mt-2" style="max-height: 120px;">
                            @endif
                        </div>
            
                        <div class="mb-3">
                            <label for="sec_image" class="form-label">Secondary Image</label>
                            <input type="file" name="sec_image" id="sec_image" class="form-control">
                            @if(isset($product) && $product->second_image)
                                <img src="{{ asset('uploads/' . $product->second_image) }}" class="img-thumbnail mt-2" style="max-height: 120px;">
                            @endif
                        </div>
                    </div>
            
                    <!-- Description -->
                    <div class="col-12 mt-2">
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea name="description" id="description" rows="4" class="form-control" placeholder="Product description">{{ old('description', $product->description ?? '') }}</textarea>
                        </div>
                    </div>
                </div>
            
                <!-- Submit Button -->
                <div class="text-end mt-3">
                    <button type="submit" class="btn btn-dark px-4 py-2">
                        <i class="fas fa-save me-2"></i> {{ isset($product) ? 'Update' : 'Create' }}
                    </button>
                </div>
            </form>
            
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const sizeInputs = document.getElementById('sizeInputs');
        const addSizeBtn = document.getElementById('addSizeBtn');

        // Function to create a new size input
        function createSizeInput(value = '') {
            const div = document.createElement('div');
            div.classList.add('input-group', 'mb-2');

            const input = document.createElement('input');
            input.type = 'text';
            input.name = 'sizes[]';
            input.classList.add('form-control');
            input.placeholder = 'Size';
            input.value = value;

            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.classList.add('btn', 'btn-danger', 'remove-btn');
            removeBtn.innerText = 'Remove';

            removeBtn.addEventListener('click', function () {
                div.remove();
            });

            div.appendChild(input);
            div.appendChild(removeBtn);
            return div;
        }

        // Add Size Button Click
        addSizeBtn.addEventListener('click', function () {
            const newInput = createSizeInput();
            sizeInputs.appendChild(newInput);
        });

        // Remove Button Click for Existing Inputs
        document.querySelectorAll('.remove-btn').forEach(function (btn) {
            btn.addEventListener('click', function () {
                btn.parentElement.remove();
            });
        });
    });
</script>


<style>
    /* Form styling */
    .form-label {
        font-weight: 500;
        margin-bottom: 0.5rem;
    }
    
    .card-header {
        padding: 1rem 1.5rem;
    }
    
    .input-group-text {
        background-color: #f8f9fa;
        min-width: 40px;
        justify-content: center;
    }
    
    textarea.form-control {
        min-height: 120px;
    }
    
    /* Size selection styling */
    .form-check-input {
        margin-top: 0.2rem;
    }
    
    /* Column spacing */
    .pe-md-3 {
        padding-right: 1rem;
    }
    .ps-md-3 {
        padding-left: 1rem;
    }
    
    /* Responsive adjustments */
    @media (max-width: 767.98px) {
        .pe-md-3, .ps-md-3 {
            padding-right: 0;
            padding-left: 0;
        }
    }
</style>
@endsection